<?php


class DroowSVG
{


    /**
     * Gets the SVG code for a given icon.
     */
    public static function getSvg( $size , $svg )
    {


        $repl = sprintf( '<svg class="svg-icon" width="%d" height="%d" aria-hidden="true" role="img" focusable="false" ' , $size , $size );
        $svg  = preg_replace( '/^<svg /' , $repl , $svg ); // Add extra attributes to SVG code.
        $svg  = preg_replace( "/([\n\t]+)/" , ' ' , $svg ); // Remove newlines & tabs.
        $svg  = preg_replace( '/>\s*</' , '><' , $svg ); // Remove white space between SVG tags.
        return $svg;

    }


    public static function Introduction( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512.002 512.002" style="enable-background:new 0 0 512.002 512.002;" xml:space="preserve">
<g>
	<g>
		<path d="M492.001,46c-9.169,0-206.208,0-216,0V20c0-11.046-8.954-20-20-20c-11.046,0-20,8.954-20,20v26c-9.75,0-207.051,0-216,0
			c-11.046,0-20,8.954-20,20s8.954,20,20,20h16v299.997c0,11.046,8.954,20,20,20h55.778l-34.103,77.987
			c-4.425,10.12,0.191,21.912,10.312,26.337c10.122,4.426,21.913-0.192,26.338-10.311l41.111-94.012h201.13l41.111,94.012
			c4.429,10.128,16.226,14.734,26.337,10.311c10.121-4.425,14.737-16.217,10.312-26.337l-34.103-77.987h55.777
			c11.046,0,20-8.954,20-20V85.999h16c11.046,0,20-8.954,20-20C512.001,54.953,503.047,46,492.001,46z M436.001,365.997
			c-3.086,0-356.302,0-360,0V85.999h360V365.997z"/>
	</g>
</g>
<g>
	<g>
		<path d="M386.001,124.999h-260c-11.046,0-20,8.954-20,20v79.999c0,11.046,8.954,20,20,20h260c11.046,0,20-8.954,20-20v-79.999
			C406.001,133.953,397.047,124.999,386.001,124.999z M366.001,204.998h-220v-40h220V204.998z"/>
	</g>
</g>
<g>
	<g>
		<path d="M356.001,286.997h-200c-11.046,0-20,8.954-20,20c0,11.046,8.954,20,20,20h200c11.046,0,20-8.954,20-20
			C376.001,295.951,367.047,286.997,356.001,286.997z"/>
	</g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
</svg>' );
    }

    public static function Video( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg viewBox="0 -62 512.00199 512" xmlns="http://www.w3.org/2000/svg"><path d="m334.808594 170.992188-113.113282-61.890626c-6.503906-3.558593-14.191406-3.425781-20.566406.351563-6.378906 3.78125-10.183594 10.460937-10.183594 17.875v122.71875c0 7.378906 3.78125 14.046875 10.117188 17.832031 3.308594 1.976563 6.976562 2.96875 10.652344 2.96875 3.367187 0 6.742187-.832031 9.847656-2.503906l113.117188-60.824219c6.714843-3.613281 10.90625-10.59375 10.9375-18.222656.027343-7.628906-4.113282-14.640625-10.808594-18.304687zm-113.859375 63.617187v-91.71875l84.539062 46.257813zm0 0"/><path d="m508.234375 91.527344-.023437-.234375c-.433594-4.121094-4.75-40.777344-22.570313-59.421875-20.597656-21.929688-43.949219-24.59375-55.179687-25.871094-.929688-.105469-1.78125-.203125-2.542969-.304688l-.894531-.09375c-67.6875-4.921874-169.910157-5.5937495-170.933594-5.59765575l-.089844-.00390625-.089844.00390625c-1.023437.00390625-103.246094.67578175-171.542968 5.59765575l-.902344.09375c-.726563.097657-1.527344.1875-2.398438.289063-11.101562 1.28125-34.203125 3.949219-54.859375 26.671875-16.972656 18.445312-21.878906 54.316406-22.382812 58.347656l-.058594.523438c-.152344 1.714844-3.765625 42.539062-3.765625 83.523437v38.3125c0 40.984375 3.613281 81.808594 3.765625 83.527344l.027344.257813c.433593 4.054687 4.746093 40.039062 22.484375 58.691406 19.367187 21.195312 43.855468 24 57.027344 25.507812 2.082031.238282 3.875.441406 5.097656.65625l1.183594.164063c39.082031 3.71875 161.617187 5.550781 166.8125 5.625l.15625.003906.15625-.003906c1.023437-.003907 103.242187-.675781 170.929687-5.597657l.894531-.09375c.855469-.113281 1.816406-.214843 2.871094-.324218 11.039062-1.171875 34.015625-3.605469 54.386719-26.019532 16.972656-18.449218 21.882812-54.320312 22.382812-58.347656l.058594-.523437c.152344-1.71875 3.769531-42.539063 3.769531-83.523438v-38.3125c-.003906-40.984375-3.617187-81.804687-3.769531-83.523437zm-26.238281 121.835937c0 37.933594-3.3125 77-3.625 80.585938-1.273438 9.878906-6.449219 32.574219-14.71875 41.5625-12.75 14.027343-25.847656 15.417969-35.410156 16.429687-1.15625.121094-2.226563.238282-3.195313.359375-65.46875 4.734375-163.832031 5.460938-168.363281 5.488281-5.082032-.074218-125.824219-1.921874-163.714844-5.441406-1.941406-.316406-4.039062-.558594-6.25-.808594-11.214844-1.285156-26.566406-3.042968-38.371094-16.027343l-.277344-.296875c-8.125-8.464844-13.152343-29.6875-14.429687-41.148438-.238281-2.710937-3.636719-42.238281-3.636719-80.703125v-38.3125c0-37.890625 3.304688-76.914062 3.625-80.574219 1.519532-11.636718 6.792969-32.957031 14.71875-41.574218 13.140625-14.453125 26.996094-16.054688 36.160156-17.113282.875-.101562 1.691407-.195312 2.445313-.292968 66.421875-4.757813 165.492187-5.464844 169.046875-5.492188 3.554688.023438 102.589844.734375 168.421875 5.492188.808594.101562 1.691406.203125 2.640625.3125 9.425781 1.074218 23.671875 2.699218 36.746094 16.644531l.121094.128906c8.125 8.464844 13.152343 30.058594 14.429687 41.75.226563 2.558594 3.636719 42.171875 3.636719 80.71875zm0 0"/></svg>' );
    }

    public static function Slider( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg height="512pt" viewBox="0 0 512 512" width="512pt" xmlns="http://www.w3.org/2000/svg"><path d="m476.363281 418.132812h-440.726562c-19.652344 0-35.636719-15.980468-35.636719-35.632812v-346.863281c0-19.652344 15.984375-35.636719 35.636719-35.636719h440.738281c19.640625 0 35.625 15.984375 35.625 35.636719v346.863281c0 19.652344-15.984375 35.632812-35.636719 35.632812zm-440.726562-401.066406c-10.242188 0-18.570313 8.328125-18.570313 18.570313v346.863281c0 10.238281 8.328125 18.566406 18.570313 18.566406h440.738281c10.238281 0 18.566406-8.328125 18.566406-18.566406v-346.863281c-.007812-10.242188-8.335937-18.570313-18.578125-18.570313zm0 0"/><path d="m476.363281 418.132812h-440.726562c-19.652344 0-35.636719-15.980468-35.636719-35.632812v-83.832031h512v83.832031c0 19.652344-15.984375 35.632812-35.636719 35.632812zm-459.296875-102.398437v66.765625c0 10.238281 8.328125 18.566406 18.570313 18.566406h440.726562c10.242188 0 18.570313-8.328125 18.570313-18.566406v-66.765625zm0 0"/><path d="m273.066406 384h-34.132812c-4.710938 0-8.535156-3.824219-8.535156-8.535156v-34.132813c0-4.710937 3.824218-8.53125 8.535156-8.53125h34.132812c4.710938 0 8.535156 3.820313 8.535156 8.53125v34.132813c0 4.710937-3.824218 8.535156-8.535156 8.535156zm-25.601562-17.066406h17.070312v-17.066406h-17.070312zm0 0"/><path d="m68.265625 196.265625c-2.183594 0-4.367187-.835937-6.03125-2.5l-25.601563-25.597656c-3.335937-3.339844-3.335937-8.730469 0-12.066407l25.601563-25.601562c3.328125-3.335938 8.738281-3.335938 12.066406 0 3.335938 3.335938 3.335938 8.730469 0 12.066406l-19.566406 19.566406 19.566406 19.566407c3.335938 3.335937 3.335938 8.730469 0 12.066406-1.664062 1.664063-3.847656 2.5-6.035156 2.5zm0 0"/><path d="m443.734375 196.265625c-2.1875 0-4.371094-.835937-6.035156-2.5-3.335938-3.335937-3.335938-8.730469 0-12.066406l19.566406-19.566407-19.566406-19.566406c-3.335938-3.335937-3.335938-8.730468 0-12.066406 3.328125-3.335938 8.738281-3.335938 12.066406 0l25.601563 25.601562c3.335937 3.335938 3.335937 8.726563 0 12.066407l-25.601563 25.597656c-1.664063 1.664063-3.847656 2.5-6.03125 2.5zm0 0"/><path d="m187.734375 128h-51.199219c-4.710937 0-8.535156-3.824219-8.535156-8.535156v-51.199219c0-4.710937 3.824219-8.53125 8.535156-8.53125h51.199219c4.710937 0 8.53125 3.820313 8.53125 8.53125v51.199219c0 4.710937-3.820313 8.535156-8.53125 8.535156zm-42.667969-17.066406h34.132813v-34.132813h-34.132813zm0 0"/><path d="m281.601562 128h-51.203124c-4.707032 0-8.53125-3.824219-8.53125-8.535156v-51.199219c0-4.710937 3.824218-8.53125 8.53125-8.53125h51.203124c4.707032 0 8.53125 3.820313 8.53125 8.53125v51.199219c0 4.710937-3.824218 8.535156-8.53125 8.535156zm-42.667968-17.066406h34.132812v-34.132813h-34.132812zm0 0"/><path d="m375.464844 128h-51.199219c-4.710937 0-8.53125-3.824219-8.53125-8.535156v-51.199219c0-4.710937 3.820313-8.53125 8.53125-8.53125h51.199219c4.710937 0 8.535156 3.820313 8.535156 8.53125v51.199219c0 4.710937-3.824219 8.535156-8.535156 8.535156zm-42.664063-17.066406h34.132813v-34.132813h-34.132813zm0 0"/><path d="m187.734375 221.867188h-51.199219c-4.710937 0-8.535156-3.824219-8.535156-8.535157v-51.199219c0-4.710937 3.824219-8.53125 8.535156-8.53125h51.199219c4.710937 0 8.53125 3.820313 8.53125 8.53125v51.199219c0 4.710938-3.820313 8.535157-8.53125 8.535157zm-42.667969-17.066407h34.132813v-34.132812h-34.132813zm0 0"/><path d="m281.601562 221.867188h-51.203124c-4.707032 0-8.53125-3.824219-8.53125-8.535157v-51.199219c0-4.710937 3.824218-8.53125 8.53125-8.53125h51.203124c4.707032 0 8.53125 3.820313 8.53125 8.53125v51.199219c0 4.710938-3.824218 8.535157-8.53125 8.535157zm-42.667968-17.066407h34.132812v-34.132812h-34.132812zm0 0"/><path d="m375.464844 221.867188h-51.199219c-4.710937 0-8.53125-3.824219-8.53125-8.535157v-51.199219c0-4.710937 3.820313-8.53125 8.53125-8.53125h51.199219c4.710937 0 8.535156 3.820313 8.535156 8.53125v51.199219c0 4.710938-3.824219 8.535157-8.535156 8.535157zm-42.664063-17.066407h34.132813v-34.132812h-34.132813zm0 0"/><path d="m187.734375 256h-51.199219c-4.710937 0-8.535156-3.824219-8.535156-8.535156 0-4.707032 3.824219-8.53125 8.535156-8.53125h51.199219c4.710937 0 8.53125 3.824218 8.53125 8.53125 0 4.710937-3.820313 8.535156-8.53125 8.535156zm0 0"/><path d="m281.601562 256h-51.203124c-4.707032 0-8.53125-3.824219-8.53125-8.535156 0-4.707032 3.824218-8.53125 8.53125-8.53125h51.203124c4.707032 0 8.53125 3.824218 8.53125 8.53125 0 4.710937-3.824218 8.535156-8.53125 8.535156zm0 0"/><path d="m375.464844 256h-51.199219c-4.710937 0-8.53125-3.824219-8.53125-8.535156 0-4.707032 3.820313-8.53125 8.53125-8.53125h51.199219c4.710937 0 8.535156 3.824218 8.535156 8.53125 0 4.710937-3.824219 8.535156-8.535156 8.535156zm0 0"/><path d="m384 512h-256c-4.710938 0-8.535156-3.824219-8.535156-8.535156v-17.082032c0-14.105468 11.480468-25.582031 25.585937-25.582031h221.898438c14.105469 0 25.585937 11.476563 25.585937 25.582031v17.082032c0 4.710937-3.824218 8.535156-8.535156 8.535156zm-247.464844-17.066406h238.929688v-8.550782c0-4.691406-3.820313-8.515624-8.515625-8.515624h-221.898438c-4.695312 0-8.515625 3.824218-8.515625 8.515624zm0 0"/><path d="m349.867188 477.867188h-187.734376c-4.710937 0-8.53125-3.824219-8.53125-8.535157 0-4.710937 3.820313-8.53125 8.53125-8.53125 30.3125 0 42.667969-14.832031 42.667969-51.199219 0-4.710937 3.820313-8.535156 8.53125-8.535156h85.335938c4.710937 0 8.53125 3.824219 8.53125 8.535156 0 36.367188 12.355469 51.199219 42.667969 51.199219 4.710937 0 8.53125 3.820313 8.53125 8.53125 0 4.710938-3.820313 8.535157-8.53125 8.535157zm-143.070313-17.066407h98.414063c-8.730469-9.933593-13.6875-24.175781-14.820313-42.667969h-68.78125c-1.132813 18.492188-6.089844 32.734376-14.8125 42.667969zm0 0"/></svg>' );
    }

    public static function VerticalImage( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg id="Capa_1" enable-background="new 0 0 427.412 427.412" height="512" viewBox="0 0 427.412 427.412" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m0 366.353h427.412v61.059h-427.412z"/><path d="m244.235 30.529h152.647v305.294h-152.647z"/><path d="m30.529 0h152.647v335.824h-152.647z"/></svg>' );
    }


    public static function BoxVertical( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m2 12a1 1 0 0 1 1-1h58a1 1 0 0 1 1 1v9h-60" fill="#57565c"/><path d="m2 21h60v31a1 1 0 0 1 -1 1h-58a1 1 0 0 1 -1-1" fill="#e0e0e2"/><circle cx="7" cy="16" fill="#ed1c24" r="2"/><circle cx="14" cy="16" fill="#ffda44" r="2"/><circle cx="21" cy="16" fill="#91cc04" r="2"/><path d="m11 29h14v12h-14z" fill="#91cc04"/><path d="m61 10h-58a2 2 0 0 0 -2 2v40a2 2 0 0 0 2 2h58a2 2 0 0 0 2-2v-40a2 2 0 0 0 -2-2zm-58 2h58v8h-58zm0 40v-30h58v30z"/><path d="m7 13a3 3 0 1 0 3 3 3 3 0 0 0 -3-3zm0 4a1 1 0 1 1 1-1 1 1 0 0 1 -1 1z"/><path d="m14 13a3 3 0 1 0 3 3 3 3 0 0 0 -3-3zm0 4a1 1 0 1 1 1-1 1 1 0 0 1 -1 1z"/><path d="m21 13a3 3 0 1 0 3 3 3 3 0 0 0 -3-3zm0 4a1 1 0 1 1 1-1 1 1 0 0 1 -1 1z"/><path d="m54 48h-8a1 1 0 0 0 0 2h8a1 1 0 0 0 0-2z"/><path d="m58 48h-1a1 1 0 0 0 0 2h1a1 1 0 0 0 0-2z"/><path d="m25 28h-14a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-12a1 1 0 0 0 -1-1zm-1 12h-12v-10h12z"/><path d="m29 30h24a1 1 0 0 0 0-2h-24a1 1 0 0 0 0 2z"/><path d="m29 34h24a1 1 0 0 0 0-2h-24a1 1 0 0 0 0 2z"/><path d="m29 38h24a1 1 0 0 0 0-2h-24a1 1 0 0 0 0 2z"/><path d="m44 40h-15a1 1 0 0 0 0 2h15a1 1 0 0 0 0-2z"/><path d="m47 40a1 1 0 0 0 0 2h1a1 1 0 0 0 0-2z"/></svg>' );
    }

    public static function Experience( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m2 12a1 1 0 0 1 1-1h58a1 1 0 0 1 1 1v9h-60" fill="#57565c"/><path d="m2 21h60v31a1 1 0 0 1 -1 1h-58a1 1 0 0 1 -1-1" fill="#e0e0e2"/><circle cx="7" cy="16" fill="#ed1c24" r="2"/><circle cx="14" cy="16" fill="#ffda44" r="2"/><circle cx="21" cy="16" fill="#91cc04" r="2"/><path d="m11 29h14v12h-14z" fill="#91cc04"/><path d="m61 10h-58a2 2 0 0 0 -2 2v40a2 2 0 0 0 2 2h58a2 2 0 0 0 2-2v-40a2 2 0 0 0 -2-2zm-58 2h58v8h-58zm0 40v-30h58v30z"/><path d="m7 13a3 3 0 1 0 3 3 3 3 0 0 0 -3-3zm0 4a1 1 0 1 1 1-1 1 1 0 0 1 -1 1z"/><path d="m14 13a3 3 0 1 0 3 3 3 3 0 0 0 -3-3zm0 4a1 1 0 1 1 1-1 1 1 0 0 1 -1 1z"/><path d="m21 13a3 3 0 1 0 3 3 3 3 0 0 0 -3-3zm0 4a1 1 0 1 1 1-1 1 1 0 0 1 -1 1z"/><path d="m54 48h-8a1 1 0 0 0 0 2h8a1 1 0 0 0 0-2z"/><path d="m58 48h-1a1 1 0 0 0 0 2h1a1 1 0 0 0 0-2z"/><path d="m25 28h-14a1 1 0 0 0 -1 1v12a1 1 0 0 0 1 1h14a1 1 0 0 0 1-1v-12a1 1 0 0 0 -1-1zm-1 12h-12v-10h12z"/><path d="m29 30h24a1 1 0 0 0 0-2h-24a1 1 0 0 0 0 2z"/><path d="m29 34h24a1 1 0 0 0 0-2h-24a1 1 0 0 0 0 2z"/><path d="m29 38h24a1 1 0 0 0 0-2h-24a1 1 0 0 0 0 2z"/><path d="m44 40h-15a1 1 0 0 0 0 2h15a1 1 0 0 0 0-2z"/><path d="m47 40a1 1 0 0 0 0 2h1a1 1 0 0 0 0-2z"/></svg>' );
    }

    public static function Service( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg height="436pt" viewBox="0 -12 436 435" width="436pt" xmlns="http://www.w3.org/2000/svg"><path d="m103 85.316406-70 36.398438v43.480468l70-36.394531zm0 0"/><path d="m283 70.96875-132-69.175781v339.445312l132 70.265625zm-19 254.691406c.0625 2.429688-1.164062 4.707032-3.226562 5.992188-1.035157.65625-2.234376 1.007812-3.460938 1.007812-1.125 0-2.230469-.277344-3.222656-.804687l-78.488282-41.339844c-2.269531-1.226563-3.65625-3.617187-3.601562-6.195313v-69.089843c-.070312-2.421875 1.152344-4.703125 3.207031-5.992188 2.035157-1.261719 4.59375-1.339843 6.699219-.199219l78.492188 41.339844c2.269531 1.226563 3.65625 3.617188 3.601562 6.195313zm-.527344-134.914062c-1.800781 3.421875-6.03125 4.734375-9.453125 2.933594l-78.558593-41.339844c-3.382813-1.820313-4.667969-6.027344-2.878907-9.425782 1.789063-3.398437 5.984375-4.722656 9.398438-2.964843l78.558593 41.34375c3.417969 1.800781 4.734376 6.03125 2.933594 9.453125zm0-59.21875c-.863281 1.644531-2.34375 2.878906-4.117187 3.429687-1.773438.550781-3.695313.371094-5.335938-.492187l-78.558593-41.34375c-3.421876-1.800782-4.734376-6.03125-2.933594-9.453125 1.800781-3.421875 6.03125-4.734375 9.453125-2.9375l78.558593 41.34375c3.421876 1.800781 4.734376 6.03125 2.933594 9.453125zm0 0"/><path d="m186 280.09375 64 33.972656v-53.265625l-64-33.976562zm0 0"/><path d="m137 1.726562-137 69.667969v340.652344l137-70.769531zm-118 115.710938c-.121094-2.578125 1.242188-4.996094 3.507812-6.226562l84.632813-43.582032c2.128906-1.128906 4.699219-1.03125 6.734375.257813 2.039062 1.285156 3.230469 3.5625 3.125 5.96875v59.21875c.101562 2.585937-1.273438 5-3.550781 6.230469l-84.679688 43.578124c-.96875.507813-2.042969.773438-3.132812.773438-1.25 0-2.476563-.359375-3.53125-1.027344-2.019531-1.300781-3.199219-3.574218-3.105469-5.972656zm94.644531 150.171875-84.933593 43.578125c-2.226563 1.152344-4.902344 1.027344-7.011719-.328125s-3.328125-3.738281-3.203125-6.242187c.128906-2.503907 1.585937-4.75 3.820312-5.886719l84.9375-43.578125c2.226563-1.152344 4.898438-1.027344 7.007813.328125s3.332031 3.738281 3.203125 6.242187c-.125 2.503906-1.585938 4.75-3.820313 5.886719zm0-49.347656-84.933593 43.578125c-2.226563 1.152344-4.902344 1.027344-7.011719-.328125s-3.328125-3.738281-3.203125-6.242188c.128906-2.503906 1.585937-4.75 3.820312-5.886719l84.9375-43.578124c2.226563-1.15625 4.898438-1.027344 7.007813.328124 2.109375 1.355469 3.332031 3.738282 3.203125 6.242188-.125 2.503906-1.585938 4.75-3.820313 5.886719zm0 0"/><path d="m436 .5-139 71.226562v340.710938l139-71.226562zm-22.921875 197.035156-84.933594 43.578125c-2.226562 1.152344-4.902343 1.027344-7.007812-.328125-2.109375-1.359375-3.332031-3.738281-3.203125-6.242187.125-2.503907 1.582031-4.75 3.820312-5.886719l84.933594-43.578125c2.230469-1.167969 4.914062-1.050781 7.03125.304687 2.117188 1.359376 3.34375 3.75 3.210938 6.261719-.132813 2.511719-1.601563 4.761719-3.851563 5.890625zm0-49.347656-84.933594 43.578125c-2.226562 1.152344-4.902343 1.027344-7.007812-.328125-2.109375-1.359375-3.332031-3.738281-3.203125-6.242188.125-2.503906 1.582031-4.75 3.820312-5.886718l84.933594-43.578125c2.230469-1.167969 4.914062-1.050781 7.03125.304687 2.117188 1.359375 3.34375 3.75 3.210938 6.261719-.132813 2.511719-1.601563 4.761719-3.851563 5.890625zm0-49.347656-84.933594 43.578125c-2.226562 1.152343-4.902343 1.027343-7.007812-.328125-2.109375-1.359375-3.332031-3.738282-3.203125-6.242188.125-2.507812 1.582031-4.75 3.820312-5.886718l84.933594-43.578126c2.230469-1.167968 4.914062-1.050781 7.03125.304688 2.117188 1.359375 3.34375 3.75 3.210938 6.261719-.132813 2.511719-1.601563 4.761719-3.851563 5.890625zm0 0"/></svg>' );
    }


    public static function FeaturePost( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg id="Layer_5" enable-background="new 0 0 64 64" height="512" viewBox="0 0 64 64" width="512" xmlns="http://www.w3.org/2000/svg"><path d="m15 57h8v2h-8z"/><path d="m47 25.618 11.236-5.618-11.236-5.618zm2-8 4.764 2.382-4.764 2.382z"/><path d="m60 10h-16c-1.654 0-3 1.346-3 3v14c0 1.654 1.346 3 3 3h6v9c0 1.103-.897 2-2 2h-5.111c1.301-1.272 2.111-3.042 2.111-5 0-3.859-3.141-7-7-7-.34 0-.672.033-1 .08v-23.08c0-2.757-2.243-5-5-5h-26c-2.757 0-5 2.243-5 5v52c0 2.757 2.243 5 5 5h19 1.943 19.057v-11.913c0-.726.518-1.347 1.231-1.477l3.199-.582c3.807-.691 6.57-4.002 6.57-7.87v-11.158h3c1.654 0 3-1.346 3-3v-14c0-1.654-1.346-3-3-3zm-21.03 41.616-.97.97-.97-.97.615-8.616h.711zm-13.544-2.616h-18.426v-38h24v25c0 2.123.954 4.025 2.452 5.31-3.868.922-6.944 3.886-8.026 7.69zm17.574-13c0 2.757-2.243 5-5 5s-5-2.243-5-5 2.243-5 5-5 5 2.243 5 5zm-30-33h12v1c0 .552-.448 1-1 1h-10c-.552 0-1-.448-1-1zm-7 0h5v1c0 1.654 1.346 3 3 3h10c1.654 0 3-1.346 3-3v-1h5c1.654 0 3 1.346 3 3v23.685c-.749.357-1.426.839-2 1.426v-20.111c0-1.103-.897-2-2-2h-24c-1.103 0-2 .897-2 2v38c0 1.103.897 2 2 2h18.051c-.03.33-.051.662-.051 1v1h-22v-47c0-1.654 1.346-3 3-3zm0 58c-1.654 0-3-1.346-3-3v-3h22v6zm49-19.842c0 2.901-2.072 5.384-4.927 5.903l-3.199.581c-1.665.303-2.874 1.752-2.874 3.445v9.913h-12v-13h-2v13h-3v-9c0-4.841 3.844-8.79 8.639-8.982l-.669 9.365 3.03 3.03 3.03-3.03-.67-9.383h7.64c2.206 0 4-1.794 4-4v-9.5c0-.827.673-1.5 1.5-1.5s1.5.673 1.5 1.5zm6-14.158c0 .552-.448 1-1 1h-3.351c-.564-1.178-1.758-2-3.149-2s-2.585.822-3.149 2h-6.351c-.552 0-1-.448-1-1v-14c0-.552.448-1 1-1h16c.552 0 1 .448 1 1z"/><path d="m9 35h10v-10h-10zm2-8h6v6h-6z"/><path d="m9 47h10v-10h-10zm2-8h6v6h-6z"/><path d="m21.707 13.707-1.414-1.414-1.293 1.293v-.586h-10v10h10v-6.586zm-10.707 1.293h6v.586l-3 3-1.293-1.293-1.414 1.414 2.293 2.293h-2.586zm6 6h-2.586l2.586-2.586z"/><path d="m21 21h8v2h-8z"/><path d="m21 17h8v2h-8z"/><path d="m23 13h6v2h-6z"/><path d="m21 25h8v2h-8z"/><path d="m21 29h8v2h-8z"/><path d="m21 33h2v2h-2z"/><path d="m25 33h2v2h-2z"/><path d="m21 37h8v2h-8z"/><path d="m21 41h4v2h-4z"/><path d="m21 45h4v2h-4z"/></svg>' );
    }


    public static function Image( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g transform="translate(1 1)">
	<g>
		<g>
			<path d="M191,127c0-35.355-28.645-64-64-64s-64,28.645-64,64s28.645,64,64,64S191,162.355,191,127z M105.667,127
				c0-11.791,9.542-21.333,21.333-21.333s21.333,9.542,21.333,21.333s-9.542,21.333-21.333,21.333S105.667,138.791,105.667,127z"/>
			<path d="M489.667-1H20.333C8.551-1-1,8.551-1,20.333v384v85.333C-1,501.449,8.551,511,20.333,511h469.333
				c11.782,0,21.333-9.551,21.333-21.333v-85.333v-384C511,8.551,501.449-1,489.667-1z M41.667,41.667h426.667V383H41.667V41.667z
				 M468.333,468.333H41.667v-42.667h426.667V468.333z"/>
			<path d="M334.085,133.248c-9.814-9.814-26.238-7.792-33.378,4.109l-49.942,83.237l-23.346-23.346
				c-8.331-8.331-21.839-8.331-30.17,0L90.582,303.915c-8.331,8.331-8.331,21.839,0,30.17s21.839,8.331,30.17,0l91.582-91.582
				l48.915,48.915c8.331,8.331,21.839,8.331,30.17,0s8.331-21.839,0-30.17l-9.555-9.555l41.373-68.954l66.013,66.013
				c8.331,8.331,21.839,8.331,30.17,0c8.331-8.331,8.331-21.839,0-30.17L334.085,133.248z"/>
		</g>
	</g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
</svg>' );
    }

    public static function Review( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg height="512pt" viewBox="0 0 512 512" width="512pt" xmlns="http://www.w3.org/2000/svg"><path d="m211 286c0 24.8125 20.1875 45 45 45s45-20.1875 45-45-20.1875-45-45-45-45 20.1875-45 45zm0 0"/><path d="m256 361c-49.628906 0-90 40.371094-90 90v61h180v-61c0-49.628906-40.371094-90-90-90zm0 0"/><path d="m136 316c0-24.8125-20.1875-45-45-45s-45 20.1875-45 45 20.1875 45 45 45 45-20.1875 45-45zm0 0"/><path d="m466 316c0-24.8125-20.1875-45-45-45s-45 20.1875-45 45 20.1875 45 45 45 45-20.1875 45-45zm0 0"/><path d="m76 0-22.820312 53.800781-53.179688 7.5 38.355469 36.433594-8.820313 53.265625 46.464844-24.285156 46.464844 24.285156-8.820313-53.265625 37.355469-36.433594-51.621094-7.5zm0 0"/><path d="m279.378906 53.800781-23.378906-53.800781-22.820312 53.800781-52.179688 7.5 37.355469 36.433594-8.820313 53.265625 46.464844-24.285156 46.464844 24.285156-8.820313-53.265625 37.355469-36.433594zm0 0"/><path d="m436 0-22.820312 53.800781-52.179688 7.5 37.355469 36.433594-8.820313 53.265625 46.464844-24.285156 46.464844 24.285156-8.820313-53.265625 38.355469-36.433594-52.621094-7.5zm0 0"/><path d="m421 391c-19.9375 0-38.183594 6.691406-53.097656 17.660156 5.019531 13.214844 8.097656 27.386719 8.097656 42.339844v61h136v-31c0-49.707031-41.292969-90-91-90zm0 0"/><path d="m0 481v31h136v-61c0-14.953125 3.078125-29.125 8.097656-42.339844-14.914062-10.96875-33.160156-17.660156-53.097656-17.660156-49.707031 0-91 40.292969-91 90zm0 0"/></svg>' );
    }
    public static function Paragraph( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg version="1.1"  xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M501.333,85.333H10.667C4.779,85.333,0,90.112,0,96s4.779,10.667,10.667,10.667h490.667
			c5.888,0,10.667-4.779,10.667-10.667S507.221,85.333,501.333,85.333z"/>
	</g>
</g>
<g>
	<g>
		<path d="M501.333,149.333H10.667C4.779,149.333,0,154.112,0,160s4.779,10.667,10.667,10.667h490.667
			c5.888,0,10.667-4.779,10.667-10.667S507.221,149.333,501.333,149.333z"/>
	</g>
</g>
<g>
	<g>
		<path d="M501.333,213.333H10.667C4.779,213.333,0,218.112,0,224s4.779,10.667,10.667,10.667h490.667
			c5.888,0,10.667-4.779,10.667-10.667S507.221,213.333,501.333,213.333z"/>
	</g>
</g>
<g>
	<g>
		<path d="M501.333,277.333H10.667C4.779,277.333,0,282.112,0,288s4.779,10.667,10.667,10.667h490.667
			c5.888,0,10.667-4.779,10.667-10.667S507.221,277.333,501.333,277.333z"/>
	</g>
</g>
<g>
	<g>
		<path d="M501.333,341.333H10.667C4.779,341.333,0,346.112,0,352c0,5.888,4.779,10.667,10.667,10.667h490.667
			c5.888,0,10.667-4.779,10.667-10.667C512,346.112,507.221,341.333,501.333,341.333z"/>
	</g>
</g>
<g>
	<g>
		<path d="M416,405.333H96c-5.888,0-10.667,4.779-10.667,10.667c0,5.888,4.779,10.667,10.667,10.667h320
			c5.888,0,10.667-4.779,10.667-10.667C426.667,410.112,421.888,405.333,416,405.333z"/>
	</g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
</svg>' );
    }

    public static function Team( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg height="496pt" viewBox="0 0 496 496" width="496pt" xmlns="http://www.w3.org/2000/svg"><path d="m496 256v-64.191406c0-17.800782-11.457031-33.199219-28.503906-38.3125l-51.496094-15.449219v-12.152344c14.488281-10.132812 24-26.910156 24-45.886719v-24.007812c0-30.878906-25.121094-56-56-56s-56 25.121094-56 56v24c0 18.984375 9.511719 35.761719 24 45.886719v12.152343l-45.382812 13.617188c-17.03125-15.230469-38.730469-23.65625-61.769532-23.65625-22.945312 0-43.9375 8.40625-60.160156 22.257812l-40.6875-12.210937v-12.152344c14.488281-10.132812 24-26.910156 24-45.886719v-24.007812c0-30.878906-25.121094-56-56-56s-56 25.121094-56 56v24c0 18.984375 9.511719 35.761719 24 45.886719v12.152343l-51.496094 15.449219c-17.046875 5.121094-28.503906 20.519531-28.503906 38.320313v64.191406h16v-64.191406c0-10.679688 6.871094-19.921875 17.105469-22.984375l51.511719-15.457031c4.65625 6.046874 13.664062 14.632812 27.382812 14.632812s22.726562-8.585938 27.382812-14.632812l32.808594 9.839843c-10.414062 13.097657-17.351562 29.039063-19.457031 46.480469-10.214844-10.855469-24.679687-17.6875-40.734375-17.6875-30.878906 0-56 25.121094-56 56v24c0 18.984375 9.511719 35.761719 24 45.886719v12.152343l-51.496094 15.449219c-17.046875 5.121094-28.503906 20.519531-28.503906 38.320313v72.191406h96c4.40625 0 8 3.59375 8 8v32h288v-32c0-4.40625 3.59375-8 8-8h96v-72.191406c0-17.800782-11.457031-33.199219-28.503906-38.3125l-51.496094-15.449219v-12.152344c14.488281-10.132812 24-26.910156 24-45.886719v-24c0-30.878906-25.121094-56-56-56-15.664062 0-29.824219 6.480469-40 16.878907v-7.582031c0-15.800782-8.585938-30.023438-21.984375-37.542969l34.601563-10.386719c4.65625 6.039062 13.664062 14.625 27.382812 14.625s22.726562-8.585938 27.382812-14.632812l51.519532 15.457031c10.226562 3.0625 17.097656 12.304687 17.097656 22.984375v64.191406zm-384-240c22.054688 0 40 17.945312 40 40h-36.6875c-5.082031 0-10.066406-2.0625-13.65625-5.65625l-5.65625-5.65625-5.65625 5.65625c-3.589844 3.59375-8.574219 5.65625-13.65625 5.65625h-4.6875c0-22.054688 17.945312-40 40-40zm-40 64v-8h4.6875c6.96875 0 13.625-2 19.3125-5.734375 5.6875 3.734375 12.34375 5.734375 19.3125 5.734375h36.6875v8c0 22.054688-17.945312 40-40 40s-40-17.945312-40-40zm40 72c-8.503906 0-14.015625-7.144531-16-10.199219v-8.152343c5.070312 1.511718 10.441406 2.351562 16 2.351562s10.929688-.839844 16-2.359375v8.152344c-1.984375 3.070312-7.496094 10.207031-16 10.207031zm219.902344 140.414062c4.074218 10.347657 11.105468 19.195313 20.097656 25.480469v12.152344l-51.488281 15.449219c-1.695313.503906-3.34375 1.160156-4.953125 1.886718l-7.558594-1.742187v-15.761719c8.550781-6.871094 15.289062-15.894531 19.425781-26.238281 9.214844-.808594 17.855469-4.730469 24.476563-11.226563zm-83.902344 51.585938c8.488281 0 16.585938-1.695312 24-4.710938v8.710938l-24 18-24-18v-8.710938c7.414062 3.015626 15.511719 4.710938 24 4.710938zm-33.824219 16.632812 19.503907 14.632813-20.0625 12.039063-5.074219-25.367188zm24.984375 63.367188h17.679688l6.222656 56h-30.125zm19.070313-16h-20.46875l-4.59375-13.777344 14.832031-8.894531 14.824219 8.894531zm4.089843-32.734375 19.503907-14.632813 5.632812 1.296876-5.074219 25.367187zm59.441407-95.121094c-2.769531 3.039063-6.289063 5.167969-10.105469 6.464844.222656-2.175781.34375-4.378906.34375-6.609375v-38.28125c8.609375 3.265625 15.015625 10.839844 15.878906 19.890625.65625 6.886719-1.511718 13.460937-6.117187 18.535156zm-25.761719-.144531c0 26.472656-21.527344 48-48 48s-48-21.527344-48-48v-40h27.160156c17.433594 0 34.398438-4.351562 49.566406-12.664062l6.328126 12.664062h12.945312zm-111.65625 6.609375c-3.816406-1.296875-7.335938-3.425781-10.105469-6.464844-4.605469-5.066406-6.773437-11.648437-6.117187-18.527343.863281-9.050782 7.269531-16.632813 15.878906-19.890626v38.273438c0 2.230469.121094 4.433594.34375 6.609375zm4.230469 17.03125c4.128906 10.34375 10.867187 19.367187 19.425781 26.238281v15.761719l-7.558594 1.742187c-1.617187-.726562-3.257812-1.375-4.945312-1.886718l-51.496094-15.449219v-12.152344c8.984375-6.285156 16.023438-15.132812 20.097656-25.480469 6.621094 6.496094 15.261719 10.417969 24.476563 11.226563zm-76.574219-95.640625c22.054688 0 40 17.945312 40 40h-4.6875c-5.082031 0-10.066406-2.0625-13.65625-5.65625l-5.65625-5.65625-5.65625 5.65625c-3.589844 3.59375-8.574219 5.65625-13.65625 5.65625h-36.6875c0-22.054688 17.945312-40 40-40zm-40 64v-8h36.6875c6.96875 0 13.625-2 19.3125-5.734375 5.6875 3.734375 12.34375 5.734375 19.3125 5.734375h4.6875v8c0 22.054688-17.945312 40-40 40s-40-17.945312-40-40zm40 56c5.558594 0 10.929688-.839844 16-2.359375v8.152344c-1.984375 3.070312-7.496094 10.207031-16 10.207031s-14.015625-7.144531-16-10.199219v-8.152343c5.070312 1.511718 10.441406 2.351562 16 2.351562zm-16 112h-32v-56h-16v56h-32v-56.191406c0-10.679688 6.871094-19.921875 17.105469-22.984375l51.511719-15.457031c4.65625 6.046874 13.664062 14.632812 27.382812 14.632812s22.726562-8.585938 27.382812-14.632812l30.335938 9.105468-22.3125 5.144532c-25.558594 5.902343-43.40625 28.34375-43.40625 54.566406v9.816406h16v-9.816406c0-18.734375 12.753906-34.757813 31.007812-38.976563l41.9375-9.679687 9.429688 47.167968 16.738281-10.039062 4.734375 14.207031-7.007812 63.136719h-40.839844v-64h-16v64h-40v-16c0-13.230469-10.769531-24-24-24zm366.894531-79.175781c10.234375 3.0625 17.105469 12.304687 17.105469 22.984375v56.191406h-32v-56h-16v56h-32c-13.230469 0-24 10.769531-24 24v16h-40v-64h-16v64h-40.839844l-7.015625-63.136719 4.734375-14.207031 16.738282 10.039062 9.429687-47.167968 41.945313 9.679687c18.253906 4.21875 31.007812 20.242188 31.007812 38.976563v9.816406h16v-9.816406c0-26.222656-17.847656-48.664063-43.40625-54.566406l-22.3125-5.144532 30.335938-9.105468c4.65625 6.046874 13.664062 14.632812 27.382812 14.632812s22.726562-8.585938 27.382812-14.632812zm-62.894531-27.023438c-1.984375 3.0625-7.496094 10.199219-16 10.199219-8.519531 0-14.039062-7.167969-16-10.199219v-8.160156c5.070312 1.519531 10.441406 2.359375 16 2.359375s10.929688-.839844 16-2.359375zm-16-21.800781c-22.054688 0-40-17.945312-40-40v-8h4.6875c6.96875 0 13.625-2 19.3125-5.734375 5.6875 3.734375 12.34375 5.734375 19.3125 5.734375h36.6875v8c0 22.054688-17.945312 40-40 40zm0-104c22.054688 0 40 17.945312 40 40h-36.6875c-5.082031 0-10.066406-2.0625-13.65625-5.65625l-5.65625-5.65625-5.65625 5.65625c-3.589844 3.59375-8.574219 5.65625-13.65625 5.65625h-4.6875c0-22.054688 17.945312-40 40-40zm-56 24.679688c-7.078125-5.359376-15.871094-8.679688-25.375-8.679688h-9.679688l-9.839843-19.679688-7.539063 5.023438c-14.390625 9.59375-31.125 14.65625-48.40625 14.65625h-33.785156c-9.503906 0-18.296875 3.320312-25.375 8.679688v-11.832032c0-42.367187 34.480469-76.847656 76.847656-76.847656 20.527344 0 39.832032 7.992188 54.34375 22.503906l8.488282 8.488282 1.792968.601562c11.078125 3.695312 18.527344 14.023438 18.527344 25.703125zm56-216.679688c22.054688 0 40 17.945312 40 40h-4.6875c-5.082031 0-10.066406-2.0625-13.65625-5.65625l-5.65625-5.65625-5.65625 5.65625c-3.589844 3.59375-8.574219 5.65625-13.65625 5.65625h-36.6875c0-22.054688 17.945312-40 40-40zm-40 64v-8h36.6875c6.96875 0 13.625-2 19.3125-5.734375 5.6875 3.734375 12.34375 5.734375 19.3125 5.734375h4.6875v8c0 22.054688-17.945312 40-40 40s-40-17.945312-40-40zm40 72c-8.519531 0-14.039062-7.167969-16-10.199219v-8.160156c5.070312 1.519531 10.441406 2.359375 16 2.359375s10.929688-.839844 16-2.359375v8.152344c-1.984375 3.070312-7.496094 10.207031-16 10.207031zm0 0"/><path d="m184 0h16v16h-16zm0 0"/><path d="m184 32h16v88h-16zm0 0"/><path d="m296 0h16v16h-16zm0 0"/><path d="m296 32h16v88h-16zm0 0"/><path d="m216 32h16v56h-16zm0 0"/><path d="m216 104h16v16h-16zm0 0"/><path d="m264 32h16v56h-16zm0 0"/><path d="m264 104h16v16h-16zm0 0"/></svg>' );
    }

public static function Contact( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M499.161,170.733L341.257,12.828c-17.091-17.091-44.901-17.091-61.992,0L32.839,259.255
			c-8.545,8.546-12.818,19.771-12.818,30.996c0,11.225,4.273,22.45,12.818,30.996l39.619,39.619l-43.503,43.503
			c-1.953,1.953-2.929,4.512-2.929,7.071s0.976,5.118,2.929,7.071c3.905,3.905,10.237,3.906,14.142,0L86.6,375.008l18.119,18.12
			L2.929,494.919C0.976,496.871,0,499.431,0,501.99c0,2.559,0.976,5.119,2.929,7.071c3.905,3.905,10.237,3.905,14.143,0
			L118.863,407.27l71.88,71.881c17.092,17.09,44.901,17.09,61.992,0l246.426-246.427C507.44,224.446,512,213.437,512,201.729
			C512,190.02,507.44,179.012,499.161,170.733z M214.473,470.833c-3.508-1.117-6.811-3.046-9.589-5.824L46.981,307.105
			c-6.231-6.232-8.263-15.079-6.138-23.036h173.63V470.833z M178.326,264.069l29.653-29.653c3.905-3.905,3.906-10.237,0-14.142
			c-3.906-3.905-10.237-3.906-14.142,0l-43.796,43.795h-29.135l90.406-90.406c3.904-3.905,3.905-10.237,0-14.143
			c-3.905-3.905-10.237-3.905-14.143,0L92.622,264.069H56.31l227.769-227.77v203.935c0,13.143-10.692,23.835-23.835,23.835H178.326z
			 M485.02,218.583L238.593,465.009c-1.271,1.271-2.659,2.352-4.119,3.276V284.069h25.771c24.17,0,43.835-19.664,43.835-43.835
			v-25.771h114.624l-57.867,57.868c-1.952,1.952-2.929,4.512-2.929,7.071c0,2.56,0.976,5.118,2.929,7.071
			c3.905,3.905,10.237,3.905,14.143,0l72.002-72.002c0.002-0.002,0.004-0.005,0.006-0.007h41.328
			C487.381,215.937,486.284,217.32,485.02,218.583z M304.079,194.463V20.833c7.958-2.125,16.805-0.093,23.036,6.138l157.904,157.904
			c2.732,2.731,4.713,6.01,5.853,9.588H304.079z"/>
	</g>
</g>
<g>
	<g>
		<path d="M235.79,135.05c-1.86-1.87-4.44-2.93-7.07-2.93c-2.64,0-5.21,1.06-7.07,2.93c-1.86,1.86-2.93,4.43-2.93,7.07
			c0,2.63,1.07,5.21,2.93,7.07c1.86,1.86,4.43,2.93,7.07,2.93c2.63,0,5.21-1.07,7.07-2.93s2.93-4.44,2.93-7.07
			C238.72,139.48,237.65,136.91,235.79,135.05z"/>
	</g>
</g>
<g>
	<g>
		<path d="M17.11,430.35c-1.86-1.86-4.44-2.93-7.07-2.93s-5.21,1.07-7.07,2.93c-1.86,1.86-2.93,4.44-2.93,7.07s1.07,5.21,2.93,7.07
			c1.86,1.86,4.44,2.93,7.07,2.93c2.64,0,5.21-1.07,7.07-2.93c1.87-1.86,2.93-4.44,2.93-7.07S18.98,432.21,17.11,430.35z"/>
	</g>
</g>
<g>
	<g>
		<path d="M127.018,449.497c-3.906-3.905-10.238-3.905-14.143,0l-45.416,45.416c-1.952,1.952-2.929,4.512-2.929,7.071
			c0,2.559,0.976,5.119,2.929,7.072c3.906,3.905,10.238,3.905,14.143,0l45.416-45.416
			C130.922,459.734,130.922,453.402,127.018,449.497z"/>
	</g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
</svg>' );
    }


    public static function Map( $size = 32 )
    {
        return self::getSvg( $size ,
            '<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<g>
	<g>
		<path d="M256,0C161.896,0,85.333,76.563,85.333,170.667c0,28.25,7.063,56.26,20.49,81.104L246.667,506.5
			c1.875,3.396,5.448,5.5,9.333,5.5s7.458-2.104,9.333-5.5l140.896-254.813c13.375-24.76,20.438-52.771,20.438-81.021
			C426.667,76.563,350.104,0,256,0z M256,256c-47.052,0-85.333-38.281-85.333-85.333c0-47.052,38.281-85.333,85.333-85.333
			s85.333,38.281,85.333,85.333C341.333,217.719,303.052,256,256,256z"/>
	</g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
</svg>' );
    }
}